unit MyScrollBar;
//uQj_C{^R|[lgvMyScrollBar Copyright 2020 Arihiko.
//2020.05.15 V1.0

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TMyScrollBar = class(TCustomControl)
  private
    { Private 錾 }
    FOnChange: TNotifyEvent;//ԕω
    FdoUe:integer;//㔼~̓x(0`100)(0`180x)
    FdoSita:integer;//~̓x(0`100)(0`180x)
    FMausDeHari:boolean;//}EXŐj𓮂(true),Ȃ(false)
    FUeDragging: Boolean;//㔼~}EXhbO
    FSitaDragging: Boolean;//㔼~}EXhbO
    FbanColor: TColor;//Ֆʂ̐F
    FUeColor: TColor;//㔼~̐j̐F
    FSitaColor:TColor;//~̐j̐F
    function GetX(Angle:Extended;R,CenterX:Integer) : Integer;//pxXW𓾂
    function GetY(Angle:Extended;R,CenterY:Integer) : Integer;//pxYW𓾂
    function getSiita(px,py:integer):integer;//}EX|Cg(X,Y)(0`100)𓾂
    procedure drawdoHari(doUS,dmyhan,cxx,cyy,uesita:integer);//ۂɐj`
    procedure SetdoUe(Value: integer);//㔼~̐j̒lZbgj`
    procedure SetdoSita(Value: integer);//~̐j̒lZbgj`
    procedure SetSeigenEgaku(var outAtai:integer; inAtai: Integer);//lj`
    procedure drawMemori;//ڐՂ̖ڐ`
    procedure SetBanColor(NewColor : TColor);//Ֆʂ̐F
    procedure SetUeColor(NewColor : TColor);//㔼~̐j̐F
    procedure SetSitaColor(NewColor : TColor);//~̐j̐F
    procedure SetMausDeHari(const Value: boolean);//}EXŐj𓮂ON/OFF
  protected
    { Protected 錾 }
    procedure Change; virtual;//lς邱Ƃm点
    procedure Paint; override;//R|[lgyCg
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseHariEgaku(X, Y: Integer; Shift: TShiftState);//ۂɐj`
  public
    { Public 錾 }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  published
    { Published 錾 }
    property OnChange: TNotifyEvent read FOnChange write FOnChange;//ԕω
    property doUe: integer read FdoUe write SetdoUe;//㔼~̐j̓x(0`100%)
    property doSita: integer read FdoSita write SetdoSita;//~̐j̓x(0`100%)
    property banColor: TColor read FbanColor write SetBanColor;//Ֆʂ̐F
    property ueColor: TColor read FueColor write SetueColor;//㔼~̐j̐F
    property sitaColor: TColor read FsitaColor write SetsitaColor;//~̐j̐F
    property mausDeHari:boolean read FmausDeHari write SetMausDeHari;//}EXŐj𓮂邩
    property PopupMenu;
    property ParentShowHint;

  end;

procedure Register;

implementation

const
  HABA_DEF = 70;//_
  TAKA_DEF = 70;//_
  UE_ = 1;//㔼~͈̔͒萔
  SITA_ = 2;//~͈̔͒萔
  UE_COLOR_DEF = clBlue;//_㔼~̐j̐F
  SITA_COLOR_DEF = clRed;//_~̐j̐F
  BAN_COLOR_DEF = clBtnface;//_ՖʐF
  DRAG_HINT = 'hbOACtrl:0, Shift:100';
  //IHintvpeBݒł邪Asɂ͖

var
  Len,cx,cy,cxUe,cyUe,cxSita,cySita:integer;
  //j̒,~̒SW(SE㔼~E~)
  mem_hankei:integer;//ڐp̉~̔a

  
procedure Register;
begin
  RegisterComponents('Samples', [TMyScrollBar]);
end;

{ TMyScrollBar }

procedure TMyScrollBar.SetSeigenEgaku(var outAtai:integer; inAtai: Integer);
var
  dmy:integer;
begin//͂l0`100͈̔͂ɐďo͂Aj`
  dmy := inAtai;
  if dmy >= 100 then dmy := 100 else if dmy <= 0 then dmy := 0;
  if outAtai <> dmy then begin
    outAtai := dmy;
    refresh;
    change;
  end;
end;

procedure TMyScrollBar.SetdoUe(Value: integer);
begin//㔼~̐j̒lZbgj`
  SetSeigenEgaku(FdoUe, value);
end;

procedure TMyScrollBar.SetdoSita(Value: integer);
begin//~̐j̒lZbgj`
  SetSeigenEgaku(FdoSita, value);
end;

procedure TMyScrollBar.Change;
begin//lς邱Ƃm点
  if Assigned(FOnChange) then FOnChange(Self);
end;

procedure TMyScrollBar.drawdoHari(doUS,dmyhan,cxx,cyy,uesita:integer);
var
  Angle,kaku:Extended;
begin//ۂɐj`(̃vV[Wŏ㔼~Ɖ~`)
  with canvas do begin
    //180xPiWA
    //[Ql]~̖k0xƂȂĂ
    //090x(-90x),100(1801.8)E90x(90x)Ƃ
    kaku := doUS * 1.8;
    font.Color := clBlack;
    brush.style := bsClear;
    font.size := 9;
    angle := 0; 

    case uesita of
      UE_:begin//㔼~
          Angle := Pi * (kaku - 90) / 180;//k[0x]90xɂ炷[Eɑ]
          Pen.Color := FueColor;
          TextOut(cx-5,cy-15,inttostr(doUS));//㔼~ɓx(0`100)\
          end;
      SITA_:begin//~
            Angle := Pi * (-kaku - 90) / 180;//k[0x]90xɂ炷[ɑ]
            Pen.Color := FsitaColor;
            TextOut(cx-5,cy+5,inttostr(doUS));//~ɓx(0`100)\
          end;
    end;//case end

    Pen.Mode := pmCopy;
    Pen.Width := 2;
    polyline([point(cxx,cyy),point(GetX(Angle,Len,cxx),GetY(Angle,Len,cyy))]);//j`
              
  end;
end;

function TMyScrollBar.GetX(Angle:Extended;R,CenterX:Integer) : Integer;
var  E : Extended;
begin
  E := Sin(Angle);
  Result := round(R * E)+(CenterX); //j̐[wW
end;

function TMyScrollBar.GetY(Angle:Extended;R,CenterY:Integer) : Integer;
var E: Extended;
begin
  E := -Cos(Angle);
  Result := round(R * E)+(CenterY); //j̐[xW
end;

constructor TMyScrollBar.Create(AOwner: TComponent);
begin//R|[lg쐬
  inherited Create(AOwner);//NGCg͂艺ɏ
  Parent  := AOwner as TWinControl;//ꂪȂƐeRg[ƌ

  //Rg[̑傫𐧌
  if width > 100 then width := 100 else if width < 50 then width := 50;
  width := HABA_DEF;
  height := width;//c~ɂ

  //eϐ̏l
  FbanColor := BAN_COLOR_DEF;//Ֆʂ̐F
  FueColor := UE_COLOR_DEF;//㔼~̐j̐F
  FsitaColor := SITA_COLOR_DEF;//~̐j̐F
  doUe := 0;//㔼~̓x=0
  doSita := 0;//~̓x=0
  FmausDeHari := true;//}EXŐj𓮂
  fUeDragging := false;//㔼~}EX͉ĂȂ
  fSitaDragging := false;//~}EX͉ĂȂ

  DoubleBuffered := True;//}

  showhint := true;
  hint := DRAG_HINT;  
end;

destructor TMyScrollBar.Destroy;
begin//R|[lgj

  inherited Destroy;//fXgC͂ɏ
end;

procedure TMyScrollBar.drawMemori;
var
  i:integer;
  x,y:integer;
  kaku:extended;
begin//10̖ڐ`
  for i := 0 to 19 do begin
    kaku := Pi * 0.1 * i;
    x := GetX(kaku,mem_hankei,cx);
    y := GetY(kaku,mem_hankei,cy);
    with canvas do begin
      pen.width := 2;
      pen.color := clBlack;
      Brush.Color := clBlack;
      Brush.Style := bsSolid;
      Ellipse(x,y,x+2,y+2);
    end;
  end;
end;


procedure TMyScrollBar.Paint;
begin//R|[lgyCg
  inherited Paint;

  //a50`100̑傫ɐ
  if width > 100 then width := 100 else if width < 50 then width := 50;
  height := width;//c~ɂ

  mem_hankei := width div 2 - 5;//ڐp̉~̔a
  Len := width div 2 - 7;//j̔a
  cx := (width div 2);//~̒SX
  cy := (height div 2);//~̒SY
  cxUe := (width div 2);//㔼~̐j̒SX
  cyUe := (height div 2) - 1;//㔼~̐j̒SY(1hbg炷)
  cxSita := (width div 2);//~̐j̒SX
  cySita := (height div 2) + 1;//~̐j̒SY(1hbg炷)

  with canvas do begin
    Brush.color := FbanColor;
    pen.color := clbtnShadow;
    pen.Width := 1;
    canvas.Ellipse(rect(0,0,width,height));//R|[lgɓhԂȉ~`

    //ۃ{^𗧑̓IɌ邽߂ɉAe
    Pen.Width := 2;
    Pen.Color := clBtnHighlight;//ɃnCCg̉~ʂ`
    Arc(2,2,width,height, cx+30,10,10,cy+30);
    Pen.Width := 1;
    Pen.Color := clbtnShadow;//㉏ɃVhEF̉~ʂ`
    Arc(1,1,width,height, cx+30,10,10,cy+30);
    Pen.Width := 2;
    Pen.Color := clBtnShadow;//EɃVhEF̉~ʂ`
    Arc(1,1,width-1,height-1, 10,cy+30,cx+30,10);
    pen.width := 1;
    Pen.Color := clBlack;//Eɍ̉~ʂ`
    Arc(1,1,width,height, 10,cy+20,cx+30,10);

    pen.color := clBlack;
    pen.Width := 1;
    polyline([point(0,cy),point(width,cy)]);//`
    drawMemori;//ڐ`
    drawdoHari(doUe,Len,cxUe,cyUe,UE_);//㔼~ɐj`
    drawdoHari(doSita,Len,cxSita,cySita,SITA_);//㔼~ɐj`
  end;

  showhint := true;
  hint := DRAG_HINT;  
end;

procedure TMyScrollBar.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin//}EX_E(j}EX|Cgɕ`)

  if (Button = mbLeft) and FmausDeHari then begin//{^ł肩}EX`ONȂ
    if y < cy then fUeDragging := True else if y > cy then fSitaDragging := True;
    MouseHariEgaku(x,y,shift);
  end;

  inherited MouseDown(Button,Shift,X,Y);
end;

function TMyScrollBar.getSiita(px, py: integer): integer;
var
  arufa :extended;
  xx,yy:extended;
  dmydmy:extended;
begin//}EXX,Y(0`100)̒l𓾂
  xx := px - cx;
  yy := py - cy;
  //0ZG[
  if yy = 0 then dmydmy := pi / 2 else dmydmy := ArcTan(xx / yy);//x,yWpx𓾂
  arufa := pi - (dmydmy + (Pi / 2));//px~̐jpɖk90xɂ炷
  result := trunc(100 * (arufa / (Pi)));//0`100Ԃ

end;

procedure TMyScrollBar.MouseUp(Button: TMouseButton; Shift: TShiftState; X,Y: Integer);
begin//}EXAbv(j}EX|CgɈʒuɂ鏈I)

  if FUeDragging then FUeDragging := false else if FSitaDragging then FSitaDragging := false;
  inherited MouseUp(Button,Shift,X,Y);
end;

procedure TMyScrollBar.MouseMove(Shift: TShiftState; X, Y: Integer);
begin//}EX[u(j}EX|Cgɕ`)
  
  if FmausDeHari then begin
    if FUeDragging and  (y < cy) then begin
      MouseHariEgaku(x,y,shift);
    end else if FSitaDragging and  (y > cy) then begin
      MouseHariEgaku(x,y,shift);
    end;
  end;
  
  inherited MouseMove(Shift,X,Y);
end;

procedure TMyScrollBar.MouseHariEgaku(X, Y: Integer; Shift: TShiftState);
var
  RegionHandle: HRgn;
begin//ۂɐj`
  RegionHandle := CreateEllipticRgnIndirect(ClientRect);
  if RegionHandle > 0 then begin
    if PtInRegion(RegionHandle, X,Y) then begin
      try
        SetFocus;
        if y <= cy then begin
          doUe := getSiita(X, Y);
          if ssCtrl in shift then doUe := 0 {ctrlL[Ă0%ɂ}
          else if ssShift in shift then doUe := 100; {ShiftL[Ă100%ɂ}
          drawdoHari(doUe,len,cxUe,cyUe,UE_);
        end else if y > cy then begin
          doSita := 100 - getSiita(X, Y);
          if ssCtrl in shift then doSita := 0 {ctrlL[Ă0%ɂ}
          else if ssShift in shift then doSita := 100; {ShiftL[Ă100%ɂ}
          drawdoHari(doSita,len,cxSita,cySita,SITA_);
        end;
        //showmessage('x='+inttostr(x)+',y='+inttostr(y)+',s='+floattostr(siita));

        //Position := CalcPosition(fMouseAngle);
        //PaintIndicator;
        {Ensure the created region is deleted}
      finally
        //DeleteObject(RegionHandle);
      end; {try/finally}
    end;
  end;
end;

procedure TMyScrollBar.SetBanColor(NewColor: TColor);
begin//Ֆʂ̐FZbg
  if (FbanColor <> NewColor) {and (NewColor <> clBtnFace)} then
  begin
    FbanColor := NewColor;
    Invalidate;
  end;
end;

procedure TMyScrollBar.SetUeColor(NewColor: TColor);
begin//㔼~̐FZbg
  if (FueColor <> NewColor) {and (NewColor <> clBtnFace)} then
  begin
    FueColor := NewColor;
    Invalidate;
  end;
end;

procedure TMyScrollBar.SetSitaColor(NewColor: TColor);
begin//~̐j̐FZbg
  if (FsitaColor <> NewColor) {and (NewColor <> clBtnFace)} then
  begin
    FsitaColor := NewColor;
    Invalidate;
  end;
end;

procedure TMyScrollBar.SetMausDeHari(const Value: boolean);
begin//}EXŐj`ON/OFF
  FmausDeHari := Value;
end;



end.
